﻿/*
VERSION:		1.1
	
USAGE:
	PLAYER_MC.walk_obj.collision  =  new WalkCollisionSystem( 
															   PLAYER_MC, 
															   PLAYER_MC.walk_obj,
															   8,
															   8
															   );
- walkInertia methods -
	// add walkInertia map collision method
	#include "collisionMethods/walkInertia/tileCollision.as"
	PLAYER_MC.walk_obj.collision.collision_array = MAP_MC.collision_array;			// add needed data
	PLAYER_MC.walk_obj.collision.collisionMethods.push( makeTileCollision() );		// add this method
	
	// add walkInertia sprite collision method
	#include "collisionMethods/walkInertia/spriteCollision.as"
	PLAYER_MC.walk_obj.collision.spriteLayer_mc = SPRITES_MC;							// add needed data
	PLAYER_MC.walk_obj.collision.collisionMethods.push( makeSpriteCollision() );		// add this method
	
	
- tileWalk methods -
	// add tileWalk map collision method
	#include "collisionMethods/tileWalk/tileCollision.as"
	PLAYER_MC.walk_obj.collision.collision_array = MAP_MC.collision_array;			// add needed data
	PLAYER_MC.walk_obj.collision.collisionMethods.push( makeTileCollision() );		// add this method
	
	// add tileWalk sprite collision method
	#include "collisionMethods/tileWalk/tileCollision.as"
	PLAYER_MC.walk_obj.collision.spriteLayer_mc = SPRITES_MC;							// add needed data
	PLAYER_MC.walk_obj.collision.collisionMethods.push( makeSpriteCollision() );		// add this method
	
	
	
NOTE:
	This system doesn't do any collision by itself.
	Collision methods must be added to it,  along with whatever data they need.
	
*/
class WalkCollisionSystem
{
	// variables
	var collisionMethods;	// List of collision functions to execute.
	var player_mc;			// Reference to the player sprite		(to get their current position)
	var walk_obj;				// Reference to the walk system		(to alter its velocities)
	var xOffset;				// Shift the collision area
	var yOffset;				// Shift the collision area
	//var collision_array;		// reference to the collision data		(to determine collision)
	//var spriteLayer_mc;	// MovieClip or Array containing sprites to collide with.
	
	
	
	// Constructor()
	function WalkCollisionSystem( player_mc, walk_obj, xOffset, yOffset )
	{
		this.collisionMethods = new Array();
		this.player_mc = player_mc;
		this.walk_obj = walk_obj;
		this.xOffset = (xOffset) ? xOffset : 0;
		this.yOffset = (yOffset) ? yOffset : 0;
	}// CONSTRUCTOR()
	
	
	
	// Main()
	function run()
	{
		for(var C=0; C<this.collisionMethods.length; C++)
		{
			this.collisionMethods[C].call( this );
		}
	}// run()
	
}// WalkCollisionSystem class